//
//  ___FILENAME___
//  ___PROJECTNAME___
//
//  Created by ___FULLUSERNAME___ on ___DATE___.
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//  ___COPYRIGHT___
//

import UIKit
import RxSwift
import RxCocoa

class ___VARIABLE_ModuleName___ViewController: UIViewController {
    
    //MARK: Core
    private var viewModel: ___VARIABLE_ModuleName___ViewModel!
    private let disposeBag = DisposeBag()
    private var listItems: [___VARIABLE_ModuleName___Model] = []
    //MARK: Init
    override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: Bundle?) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    //MARK: Life cycle
    override func viewDidLoad() {
        super.viewDidLoad()
        bindViewModel()
    }
    
    //MARK: Method
    private func bindViewModel() {
        viewModel = ___VARIABLE_ModuleName___ViewModel()
        
        let input = ___VARIABLE_ModuleName___ViewModel.Input(loadTrigger: Driver.just(Void()))
        
        let output = viewModel.tranform(input)
        
        output.error.drive(onNext: { [weak self] error in
           
        }).disposed(by: disposeBag)
        
        output.listItemsSuccess.drive(onNext: { [weak self] list in
            guard let self = self else { return }
            self.listItems = list
        }).disposed(by: disposeBag)
        
        output.loading.drive(self.rx.isFetching).disposed(by: disposeBag)
    }
}
