//
//  ___FILENAME___
//  ___PROJECTNAME___
//
//  Created by ___FULLUSERNAME___ on ___DATE___.
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//  ___COPYRIGHT___
//

import RxSwift
import RxCocoa

final class ___VARIABLE_ModuleName___ViewModel: NSObject, ViewModelType {
    //MARK: Properties
    private var repository: ___VARIABLE_ModuleName___Repository = ___VARIABLE_ModuleName___RepositoryImpl()

    private let disposedBag = DisposeBag()
    var listItems: [___VARIABLE_ModuleName___Model] = []

    private var pageIndex = 1
    private var canLoadMore = true
    private let pageSize = 20

    //MARK: Init
    init() {
        super.init()
    }
    
    // MARK: - Public
    func tranform(_ input: Input)-> Output {
        let activityIndicator = ActivityIndicator()
        let errorTracker = ErrorTracker()
        let listItemsSuccess = PublishSubject<[___VARIABLE_ModuleName___Model]>()
        
        input.loadTrigger.drive(onNext: {
            self.repository
                .getList(keyword: "", pageIndex: self.pageIndex, pageSize: self.pageSize)
                .trackActivity(activityIndicator)
                .trackError(errorTracker)
                .subscribe(onNext: { list in
                    self.listItems = list
                    listItemsSuccess.onNext(list)
                }, onError: { error in
                    listItemsSuccess.onNext([])
                    AppViewController.shared()?.handleError(error)
                }, onCompleted: {
                    listItemsSuccess.onNext(self.listItems)
                })
                .disposed(by: self.disposedBag)
        }).disposed(by: disposedBag)
        
        return Output(loading: activityIndicator.asDriver(),
                      error: errorTracker.asDriver(),
                      listItemsSuccess: listItemsSuccess.asDriverOnErrorJustComplete())
    }
}

extension ___VARIABLE_ModuleName___ViewModel {
    struct Input {
        let loadTrigger: Driver<Void>
    }
    
    struct Output {
        let loading: Driver<Bool>
        let error: Driver<Error>
        let listItemsSuccess: Driver<[___VARIABLE_ModuleName___Model]>
    }
}
