//
//  ___FILENAME___
//  ___PROJECTNAME___
//
//  Created by ___FULLUSERNAME___ on ___DATE___.
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//  ___COPYRIGHT___
//

import RxSwift

protocol ___VARIABLE_ModuleName___Repository {
    func getList(keyword: String, pageIndex: Int, pageSize: Int) -> Observable<[___VARIABLE_ModuleName___Model]>
}

final class ___VARIABLE_ModuleName___RepositoryImpl: ___VARIABLE_ModuleName___Repository {
    func getList(keyword: String, pageIndex: Int, pageSize: Int) -> Observable<[___VARIABLE_ModuleName___Model]> {
        let params: [String: Any] = [
                                     "pageIndex": pageIndex,
                                     "size": pageSize,
                                     "keywordSearch": keyword]
        return Observable.create { observable in
            _ = APIRequest()
                .requestRx(url: "", method: .get, contentType: .urlFormEncoded, allHTTPHeaderFields: [:], params: params)
                .asObservable()
                .subscribe { json in
                    do {
                        let jsonData = try json.rawData()
                        let res = try JSONDecoder().decode([___VARIABLE_ModuleName___Model].self, from: jsonData)
                        observable.onNext(res)
                        observable.onCompleted()
                    } catch(let error) {
                        observable.onError(error)
                    }
                } onError: { error in
                    observable.onError(error)
                }
            return Disposables.create()
        }
    }
}


