//
//  ___FILENAME___
//  ___PROJECTNAME___
//
//  Created by ___FULLUSERNAME___ on ___DATE___.
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//  ___COPYRIGHT___
//

import UIKit
import RxSwift
import RxCocoa

class ___VARIABLE_ModuleName___ViewController: UIViewController {
    
    //MARK: Core
    private var viewModel: ___VARIABLE_ModuleName___ViewModel!
    private let disposeBag = DisposeBag()
    //MARK: Init
    override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: Bundle?) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    //MARK: Life cycle
    override func viewDidLoad() {
        super.viewDidLoad()
        bindViewModel()
    }
    
    //MARK: Method
    private func bindViewModel() {
        viewModel = ___VARIABLE_ModuleName___ViewModel()
        
        let input = ___VARIABLE_ModuleName___ViewModel.Input(loadTrigger: Driver.just(Void()))
        
        let output = viewModel.tranform(input)
        
        output.error.drive(onNext: { [weak self] error in
            guard let self = self else {return}
            if (error is NSError) {
                let error = error as NSError
//                let usernameError = error.userInfo["username"] as? String ?? ""
//                let passwordError = error.userInfo["password"] as? String ?? ""
                var errorString = ""
//                if (usernameError.isEmpty == false) {
//                    errorString += "\(self.userNameLabel.text ?? ""): \(usernameError)"
//                }
//                
//                if (passwordError.isEmpty == false) {
//                    if (errorString.isEmpty == false) {
//                        errorString += "\n"
//                    }
//                    errorString += "\(self.passwordLabel.text ?? ""): \(passwordError)"
//                }
                
                let errorResponsive = error.userInfo["error"] as? String ?? ""
                if (errorResponsive.isEmpty == false) {
                    if (errorString.isEmpty == false) {
                        errorString += "\n"
                    }
                    errorString += "\(errorResponsive)"
                }
                if errorString.isEmpty {
                    errorString = error.localizedDescription
                }
                if errorString.isEmpty {
                    errorString = error.localizedFailureReason ?? ""
                }
                self.showAlertCustom(body: errorString, agreeString: "OK", backgroundHeader: UIColor.backgroundColor.alertError, showCancel: false)
            } else {
                self.showAlertCustom(body: error.localizedDescription, agreeString: "OK", backgroundHeader: UIColor.backgroundColor.alertError, showCancel: false)
            }
           
        }).disposed(by: disposeBag)
        
        output.model.drive(onNext: { [weak self] model in
            guard let self = self else { return }
        }).disposed(by: disposeBag)
        
        output.loading.drive(self.rx.isFetching).disposed(by: disposeBag)
    }
}
