//
//  ___FILENAME___
//  ___PROJECTNAME___
//
//  Created by ___FULLUSERNAME___ on ___DATE___.
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//  ___COPYRIGHT___
//

import RxSwift
import RxCocoa

final class ___VARIABLE_ModuleName___ViewModel: NSObject, ViewModelType {
    //MARK: Properties
    private var repository: ___VARIABLE_ModuleName___Repository = ___VARIABLE_ModuleName___RepositoryImpl()

    private let disposedBag = DisposeBag()
    var result: ___VARIABLE_ModuleName___Model?

    //MARK: Init
    override init() {
        super.init()
    }
    
    // MARK: - Public
    func tranform(_ input: Input)-> Output {
        let activityIndicator = ActivityIndicator()
        let errorTracker = ErrorTracker()
        let model = PublishSubject<___VARIABLE_ModuleName___Model?>()
        
        let parameters = [
            "OpeCode": "00000",
            "Password": "000000",
            "StoreNo": "41007",
            "IdentityNo": "1000000000000006",
            "IpAddress": AppConfig.ipAddress,
            "HostName": UIDevice.current.systemName
        ]
        
        input.loadTrigger.drive(onNext: {
            self.repository
                .test(parameters: parameters.soapBodyNormal)
                .trackActivity(activityIndicator)
                .trackError(errorTracker)
                .subscribe(onNext: { item in
                    model.onNext(item)
                }, onError: { error in
                    model.onNext(nil)
                })
                .disposed(by: self.disposedBag)
        }).disposed(by: disposedBag)
        
        return Output(loading: activityIndicator.asDriver(),
                      error: errorTracker.asDriver(),
                      model: model.asDriverOnErrorJustComplete())
    }
}

extension ___VARIABLE_ModuleName___ViewModel {
    struct Input {
        let loadTrigger: Driver<Void>
    }
    
    struct Output {
        let loading: Driver<Bool>
        let error: Driver<Error>
        let model: Driver<___VARIABLE_ModuleName___Model?>
    }
}
