//
//  ___FILENAME___
//  ___PROJECTNAME___
//
//  Created by ___FULLUSERNAME___ on ___DATE___.
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//  ___COPYRIGHT___
//

import SwiftUI

struct ___VARIABLE_ModuleName___RowView: View {
    var model: ___VARIABLE_ModuleName___Model
    var lastRow: Bool = false
    @ObservedObject var remoteImageUrl: RemoteImageUrl
    
    init(model: ___VARIABLE_ModuleName___Model, lastRow: Bool) {
        self.model = model
        self.lastRow = lastRow
        remoteImageUrl = RemoteImageUrl(imageUrl: model.avatarString ?? "")
    }
    
    var body: some View {
        return GeometryReader {
            (geometry) in
            VStack() {
                Spacer()
                Image(uiImage: (((remoteImageUrl.data.isEmpty) ? UIImage(systemName: "photo") : UIImage(data: remoteImageUrl.data)) ?? UIImage())).resizable().aspectRatio(contentMode: .fit).frame(width: 150, height: 150)
                Text("\(model.firstName ?? "") \(model.lastName ?? "")")
                Text("\(model.email ?? "")")
                if !self.lastRow {
                    Divider().padding(.vertical, 12)
                } else {
                    Spacer()
                }
            }.frame(width: geometry.size.width, height: geometry.size.height, alignment: .center)
        }
    }
}
