//
//  ___FILENAME___
//  ___PROJECTNAME___
//
//  Created by ___FULLUSERNAME___ on ___DATE___.
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//  ___COPYRIGHT___
//

import SwiftUI

struct ___VARIABLE_ModuleName___CellView: View {
    var model: ___VARIABLE_ModuleName___Model
    var lastRow: Bool = false
    @ObservedObject var remoteImageUrl: RemoteImageUrl
    
    init(model: ___VARIABLE_ModuleName___Model, lastRow: Bool) {
        self.model = model
        self.lastRow = lastRow
        remoteImageUrl = RemoteImageUrl(imageUrl: model.avatarString ?? "")
    }
    
    var body: some View {
        return GeometryReader {
            (geometry) in
            VStack() {
                Spacer(minLength: 10)
                Image(uiImage: (((remoteImageUrl.data.isEmpty) ? UIImage(systemName: "photo") : UIImage(data: remoteImageUrl.data)) ?? UIImage())).resizable().aspectRatio(contentMode: .fit).frame(height: 120)
                Text("\(model.firstName ?? "") \(model.lastName ?? "")").font(Font.system(size: 14, weight: .semibold, design: .default)).frame(height: 30)
                Text("\(model.email ?? "")").font(Font.system(size: 13, weight: .regular, design: .default)).frame(height: 40)
                Spacer(minLength: 10)
            }.frame(width: geometry.size.width, height: geometry.size.height, alignment: .center)
        }
    }
}
