//
//  ___FILENAME___
//  ___PROJECTNAME___
//
//  Created by ___FULLUSERNAME___ on ___DATE___.
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//  ___COPYRIGHT___
//

import SwiftUI

struct ___VARIABLE_ModuleName___View: View {
//    @Environment(\.presentationMode) var mode: Binding<PresentationMode>
    @ObservedObject private var viewModel = ___VARIABLE_ModuleName___ViewModel()
    @State private var scrollViewContentOffset = CGFloat(0)
    @State private var contentSizeHeight = CGFloat(0)
    
    init() {
        UITableView.appearance().separatorColor = .clear
    }
    
    var body: some View {
        BaseView(title: "List", rightBarButtonImage: Image(systemName: "plus"), isLoading: $viewModel.loading) {
            BaseScrollView(.vertical, showIndicators: true, contentOffset: $scrollViewContentOffset) {
                if scrollViewContentOffset < -25  {
                    Text("Tải lại...").font(.caption2).foregroundColor(.blue)
                }
                LazyVGrid(columns: viewModel.columns, spacing: viewModel.spacing) {
                    ForEach(viewModel.models.indices, id: \.self) { index in
                        ___VARIABLE_ModuleName___CellView(model: viewModel.models[index], lastRow: index == viewModel.models.count - 1).frame(height: 220).onTapGesture {
                            viewModel.setModelDelected(viewModel.models[index])
                        }.padding(EdgeInsets(top: 10, leading: 10, bottom: 10, trailing: 10)).background(.red)
                    }
                }.padding(viewModel.padding).onChange(of: scrollViewContentOffset, perform: { value in
                    print("scrollViewContentOffset", scrollViewContentOffset)
                    // Do something
                    if scrollViewContentOffset < -100 {
                        viewModel.refreshData()
                    }
                    
                    if scrollViewContentOffset > contentSizeHeight {
                        viewModel.loadMore()
                    }
                }).frame(maxWidth: .infinity)
                .overlay(
                    GeometryReader { proxy in
                        Color.clear.onAppear { print("contentSize: ",proxy.size.height)
                            contentSizeHeight = proxy.size.height/2
                        }
                    }
                )
                if scrollViewContentOffset > contentSizeHeight - viewModel.padding.top*2 {
                    Text("Xem thêm...").font(.caption2).foregroundColor(.orange)
                }
            }.padding(EdgeInsets(top: 30, leading: 0, bottom: 30, trailing: 0))
        } rightBarButtonClick: {
//            self.mode.wrappedValue.dismiss()
        }.onAppear() {
            viewModel.refreshData()
        }//.navigate(to: NextView(item: viewModel.modelSelected ?? ___VARIABLE_ModuleName___Model()), when: $viewModel.nextScreen)
    }
}

struct ___VARIABLE_ModuleName___View_Previews: PreviewProvider {
    static var previews: some View {
        ___VARIABLE_ModuleName___View()
    }
}
