//
//  UIDevice+Ext.swift
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//

import SwiftUI
extension UIDevice {
    /// Returns `true` if the device has a notch
    var hasNotch: Bool {
        guard let scene = UIApplication.shared.connectedScenes.first,
              let windowSceneDelegate = scene.delegate as? UIWindowSceneDelegate,
              let window = windowSceneDelegate.window else { return false }
        if UIDevice.current.orientation.isPortrait {
            return (window?.safeAreaInsets.top ?? 0) > 43
        } else {
            return (window?.safeAreaInsets.left ?? 0) > 0 || (window?.safeAreaInsets.right ?? 0) > 0
        }
    }
}

extension Bundle {
    var releaseVersionNumber: String? {
        return infoDictionary?["CFBundleShortVersionString"] as? String
    }
    var buildVersionNumber: String? {
        return infoDictionary?["CFBundleVersion"] as? String
    }
}
