//
//  BaseView.swift
//
//  The template was designed by Hưng Nguyễn. 
//  Website, application (native/flutter), hosting, SEO.
//  Email: hungnguyen.it36@gmail.com
//

import SwiftUI

struct BaseView<Content: View>: View {
    @State var title: String = ""
    @State var subTitle: String = ""
    @State var backgroundColor: Color = .white
    @State var leftBarButtonTitle: String = ""
    @State var leftBarButtonImage: Image? = nil
    @State var rightBarButtonTitle: String = ""
    @State var rightBarButtonImage: Image? = nil
    @Binding var isLoading: Bool
    @ViewBuilder var viewBuilder: () -> Content
    @State var leftBarButtonClick: (()->())? = nil
    @State var rightBarButtonClick: (()->())? = nil
    
    var body: some View {
        GeometryReader {
            (geometry) in
            LoadingView(isShowing: $isLoading, title: "Loadding...") {
                NavigationView { // <1>
                    VStack {
                        self.viewBuilder().frame(minHeight: geometry.frame(in: .global).height)
                    }
                    .navigationBarTitleDisplayMode(.inline)
                    .toolbar { // <2>
                        
                        ToolbarItem(placement: .navigationBarLeading) {
                            Button {
                                if leftBarButtonTitle.count > 0 || leftBarButtonImage != nil {
                                    leftBarButtonClick?()
                                }
                            } label: {
                                if leftBarButtonTitle.count == 0 {
                                    leftBarButtonImage
                                } else {
                                    Text(leftBarButtonTitle)
                                }
                            }

                        }
                        ToolbarItem(placement: .principal) { // <3>
                            VStack {
                                Text(title).font(.headline)
                                if subTitle.count > 0 {
                                    Text(subTitle).font(.subheadline)
                                }
                            }
                        }
                        ToolbarItem(placement: .navigationBarTrailing) {
                            Button {
                                if rightBarButtonTitle.count > 0 || rightBarButtonImage != nil {
                                    rightBarButtonClick?()
                                }
                            } label: {
                                if rightBarButtonTitle.count == 0 {
                                    rightBarButtonImage
                                } else {
                                    Text(rightBarButtonTitle)
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
